package api

import (
	"regexp"

	"github.com/labstack/echo/v4"
)

var (
	validOriginRe = regexp.MustCompile(`^https://.*\.yandex-team.ru(?::\d+)?/?$`)
)

func corsMiddleware(next echo.HandlerFunc) echo.HandlerFunc {
	return func(c echo.Context) error {
		req := c.Request()
		res := c.Response()
		origin := req.Header.Get(echo.HeaderOrigin)

		if origin != "" && validOriginRe.MatchString(origin) {
			res.Header().Add(echo.HeaderVary, echo.HeaderOrigin)
			res.Header().Set(echo.HeaderAccessControlAllowOrigin, origin)
			res.Header().Set(echo.HeaderAccessControlAllowCredentials, "true")
		}

		return next(c)
	}
}
