package api

import (
	"time"

	"a.yandex-team.ru/security/xray/pkg/xrayrpc"
)

type StageStatusIssues struct {
	Low    uint32 `json:"low"`
	Medium uint32 `json:"medium"`
	High   uint32 `json:"high"`
}

type StageStatusRsp struct {
	AnalysisStatusID xrayrpc.AnalysisStatusKind `json:"analysis_status_id"`
	AnalysisStatus   string                     `json:"analysis_status"`
	StageHealthID    xrayrpc.StageHealthKind    `json:"stage_health_id"`
	StageHealth      string                     `json:"stage_health"`
	UpdatedAt        time.Time                  `json:"updated_at"`
	Issues           StageStatusIssues          `json:"issues"`
}

func statusName(status xrayrpc.AnalysisStatusKind) string {
	switch status {
	case xrayrpc.AnalysisStatusKind_ASK_UNKNOWN:
		return "unknown"
	case xrayrpc.AnalysisStatusKind_ASK_START:
		return "started"
	case xrayrpc.AnalysisStatusKind_ASK_DONE:
		return "done"
	case xrayrpc.AnalysisStatusKind_ASK_FAIL:
		return "failed"
	case xrayrpc.AnalysisStatusKind_ASK_ABORT:
		return "aborted"
	default:
		return status.String()
	}
}
