package common

import (
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/library/go/core/buildinfo"
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/xray/internal/servers/humanizer/controllers"
	"a.yandex-team.ru/security/xray/internal/servers/humanizer/infra"
)

var _ controllers.Controller = (*Controller)(nil)

type Controller struct {
	*infra.Infra
}

func (c *Controller) BuildRoute(g *echo.Group) {
	g.GET("/ping", c.ping)
	g.GET("/version", c.version)
}

func (c *Controller) ping(e echo.Context) error {
	if _, err := c.TVM.GetStatus(e.Request().Context()); err != nil {
		c.Logger.Error("failed to ping tvm client", log.Error(err))
		return e.String(http.StatusInternalServerError, "tvm failed")
	}

	return e.String(http.StatusOK, "OK")
}

func (c *Controller) version(e echo.Context) error {
	return e.String(http.StatusOK, buildinfo.Info.ProgramVersion)
}
