package watcher

import (
	"time"

	"github.com/karlseguin/ccache/v2"
)

type StageCache struct {
	cache *ccache.Cache
}

func NewStageCache() *StageCache {
	return &StageCache{
		cache: ccache.New(ccache.Configure().MaxSize(1 << 15)),
	}
}

func (c *StageCache) Close() {
	c.cache.Stop()
}

func (c *StageCache) GetStageRevision(stageID string) uint32 {
	item := c.cache.Get(stageID + "@revision")
	if item == nil || item.Expired() {
		return 0
	}

	return item.Value().(uint32)
}

func (c *StageCache) SetStageRevision(stageID string, revision uint32) {
	c.cache.Set(stageID+"@revision", revision, 60*time.Minute)
}

func (c *StageCache) DeleteStage(stageID string) {
	c.cache.Delete(stageID + "@revision")
}
