package config

import (
	"context"
	"os"

	"github.com/heetch/confita"
	"github.com/heetch/confita/backend/env"
	"github.com/heetch/confita/backend/file"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/security/xray/internal/logutil"
)

type Xray struct {
	Addr     string       `yaml:"addr"`
	Insecure bool         `yaml:"insecure"`
	TvmID    tvm.ClientID `yaml:"tvm_id"`
}

type YP struct {
	Token string `yaml:"token"`
}

type YT struct {
	Proxy string `yaml:"proxy"`
	Token string `yaml:"token"`
	Path  string `yaml:"path"`
}

type Config struct {
	LogLvl       logutil.Level `yaml:"log_level"`
	Xray         Xray          `yaml:"xray"`
	YP           YP            `yaml:"yp"`
	YT           YT            `yaml:"yt"`
	TvmSource    string        `yaml:"tvm_source"`
	ExclAccounts []string      `yaml:"excluded_accounts"`
}

func Load(cfgPath string) (*Config, error) {
	cfg := &Config{
		LogLvl: logutil.Level{
			Level: log.DebugLevel,
		},
		YP: YP{
			Token: os.Getenv("YP_TOKEN"),
		},
		YT: YT{
			Token: os.Getenv("YT_TOKEN"),
			Proxy: "locke",
			Path:  "//home/security/xray/dev",
		},
	}

	loader := confita.NewLoader(env.NewBackend(), file.NewBackend(cfgPath))
	if err := loader.Load(context.Background(), cfg); err != nil {
		return nil, err
	}

	return cfg, nil
}
