package inspect

import (
	"strings"

	"github.com/OneOfOne/xxhash"

	"a.yandex-team.ru/security/libs/go/porto"
	"a.yandex-team.ru/security/xray/pkg/xrayrpc"
)

const (
	LayerPrefix = "xlayer"

	layerAlreadyExistsErrno  = 18
	volumeAlreadyExistsErrno = 12
	containerCapabilities    = 0 |
		porto.CapChown |
		porto.CapDacOverride |
		porto.CapFowner |
		porto.CapFsetid |
		porto.CapKill |
		porto.CapMknod |
		porto.CapSetfcap
)

var (
	propsEscaper = strings.NewReplacer(";", "\\;")
)

func targetPathID(targetPath *xrayrpc.TargetPath) string {
	var path []string
	parent := targetPath
	for ; parent != nil; parent = parent.Parent {
		path = append([]string{parent.Name}, path...)
	}

	return strings.Join(path, ".")
}

func checksum(data string) uint64 {
	return xxhash.ChecksumString64(data)
}

func joinProps(props []string) string {
	var out strings.Builder
	for _, prop := range props {
		out.WriteString(propsEscaper.Replace(prop))
		out.WriteByte(';')
	}
	return out.String()
}
