package inspect

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/libs/go/porto"
	"a.yandex-team.ru/security/xray/internal/storage/layerstorage"
	"a.yandex-team.ru/security/xray/internal/storage/resstorage"
	"a.yandex-team.ru/security/xray/internal/storage/s3storage"
	"a.yandex-team.ru/security/xray/pkg/checks"
	"a.yandex-team.ru/security/xray/pkg/collectors"
)

type Option func(inspector *Inspector)

func WithOutputLogger(l log.Logger) Option {
	return func(inspector *Inspector) {
		inspector.outL = l
	}
}

func WithChecks(checks checks.Checks) Option {
	return func(inspector *Inspector) {
		inspector.checks = checks
	}
}

func WithCollectors(collectors collectors.Collectors) Option {
	return func(inspector *Inspector) {
		inspector.collectors = collectors
	}
}

func WithLogger(l log.Logger) Option {
	return func(inspector *Inspector) {
		inspector.l = l
	}
}

func WithPortoOpts(portoOpts map[string]string) Option {
	return func(inspector *Inspector) {
		inspector.portoOpts = portoOpts
	}
}

func WithLayerStorage(storage *layerstorage.Storage) Option {
	return func(inspector *Inspector) {
		inspector.layerStorage = storage
	}
}

func WithResourcesStorage(storage *resstorage.Storage) Option {
	return func(inspector *Inspector) {
		inspector.resourceStorage = storage
	}
}

func WithS3Storage(storage *s3storage.Storage) Option {
	return func(inspector *Inspector) {
		inspector.s3Storage = storage
	}
}

func WithPortoAPI(api *porto.API) Option {
	return func(inspector *Inspector) {
		inspector.porto = api
	}
}

func WithWorkDir(workDir string) Option {
	return func(inspector *Inspector) {
		inspector.workDir = workDir
	}
}

func WithAnalyzeID(analyzeID string) Option {
	return func(inspector *Inspector) {
		inspector.analyzeID = analyzeID
	}
}
