package splunk

import (
	"time"

	"a.yandex-team.ru/security/xray/internal/servers/worker/results"
)

type Results struct {
	Time    time.Time
	Spent   time.Duration
	Results *results.Analyze
}

type Event struct {
	Timestamp  int64       `json:"time"`
	SourceType string      `json:"sourcetype"`
	Index      string      `json:"index"`
	Data       interface{} `json:"event"`
}

type BaseDataEvent struct {
	AnalysisID    string `json:"analysis_id"`
	StageID       string `json:"stage_id"`
	StageRevision uint32 `json:"stage_revision"`
	StageUUID     string `json:"stage_uuid"`
}

type AnalysisComplete struct {
	BaseDataEvent
	EventType         string  `json:"event_type"`
	Status            string  `json:"status"`
	StatusDescription string  `json:"status_description"`
	Duration          float64 `json:"duration"`
}

type Issue struct {
	BaseDataEvent
	EventType string      `json:"event_type"`
	IssueKind string      `json:"issue_kind"`
	IssueType string      `json:"issue_type"`
	Severity  string      `json:"severity"`
	Target    string      `json:"target"`
	Details   interface{} `json:"details"`
}

type Warning struct {
	BaseDataEvent
	EventType string `json:"event_type"`
	Target    string `json:"target"`
	Message   string `json:"message"`
}
