package vuln

import (
	"fmt"

	"a.yandex-team.ru/security/xray/pkg/xrayrpc"
	"a.yandex-team.ru/security/yadi/libs/versionarium"
)

var (
	vulnRanges map[string][]versionarium.VersionRange
)

func init() {
	vulnRanges = make(map[string][]versionarium.VersionRange)
	vulnVersions := map[string][]string{
		"spring-beans":     {"[5.3.0, 5.3.18)", "[0, 5.2.20)"},
		"spring.beans":     {"[5.3.0, 5.3.18)", "[0, 5.2.20)"},
		"Spring Framework": {"[5.3.0, 5.3.18)", "[0, 5.2.20)"},
	}
	for lib, versions := range vulnVersions {
		for _, version := range versions {
			vulnRange, err := versionarium.NewRange("java", version)
			if err != nil {
				panic(fmt.Sprintf("can't parse vulns range: %v", err))
			}
			vulnRanges[lib] = append(vulnRanges[lib], vulnRange)
		}
	}
}

func IsVulnerable(javaInfo *xrayrpc.Spring4ShellFinderFindingDetail_Spring4ShellInfo) bool {
	curVer, err := versionarium.NewVersion("java", javaInfo.Version)
	if err != nil {
		return false
	}

	for _, vulnRange := range vulnRanges[javaInfo.Name] {
		isVuln := vulnRange.Check(curVer)
		if isVuln {
			return true
		}
	}

	return false
}
