package stagehealth

import (
	"a.yandex-team.ru/security/xray/internal/dbmodels"
	"a.yandex-team.ru/security/xray/pkg/xrayrpc"
)

func Calculate(stageOverview dbmodels.StageOverview) xrayrpc.StageHealthKind {
	switch {
	case stageOverview.Issues.High > 0:
		return xrayrpc.StageHealthKind_SHK_CRITICAL
	case stageOverview.Issues.Medium > 0 || stageOverview.Issues.Low > 0:
		return xrayrpc.StageHealthKind_SHK_WARNING
	default:
		return xrayrpc.StageHealthKind_SHK_OK
	}
}
