package fetcher

import (
	"context"
	"fmt"
	"net/http"
	"net/url"
	"os"
	"path"
	"path/filepath"

	"a.yandex-team.ru/security/libs/go/ioatomic"
)

func (f *Fetcher) httpDownload(ctx context.Context, uri URI, dst string) (int64, error) {
	parsedURI, err := url.Parse(uri.Target)
	if err != nil {
		return 0, fmt.Errorf("can't parse http url: %w", err)
	}

	if !f.singleFileMode {
		if err := os.MkdirAll(dst, 0o755); err != nil {
			return 0, fmt.Errorf("failed to create target directory: %w", err)
		}

		dst = filepath.Join(dst, path.Base(parsedURI.Path))
	}

	req, err := http.NewRequestWithContext(ctx, "GET", uri.Target, nil)
	if err != nil {
		return 0, fmt.Errorf("create request: %w", err)
	}

	req.Header.Set("User-Agent", "X-Ray <security@yandex-team.ru>")
	resp, err := f.httpc.Do(req)
	if err != nil {
		return 0, err
	}
	defer func() { _ = resp.Close }()

	layerSize := resp.ContentLength
	if layerSize > f.maxSize {
		return 0, fmt.Errorf("max size exceed %d > %d", layerSize, f.maxSize)
	}

	if resp.StatusCode != http.StatusOK {
		return 0, fmt.Errorf("invalid response status: %d", resp.StatusCode)
	}

	err = ioatomic.WriteFile(dst, resp.Body, 0644)
	if err != nil {
		return 0, fmt.Errorf("failed to download layer: %w", err)
	}

	return layerSize, nil
}
