package fetcher

import "a.yandex-team.ru/library/go/core/log"

type Option func(*Fetcher)

func WithLogger(l log.Logger) Option {
	return func(d *Fetcher) {
		d.log = l
	}
}

func WithMaxSize(maxSize int64) Option {
	return func(d *Fetcher) {
		d.maxSize = maxSize
	}
}

func WithSingleFileMode() Option {
	return func(d *Fetcher) {
		d.singleFileMode = true
	}
}
