package rescache

import "a.yandex-team.ru/library/go/core/log"

type Option func(*Cache)

func WithMaxSize(size int64) Option {
	return func(c *Cache) {
		c.maxSize = size
	}
}

func WithLogger(log log.Logger) Option {
	return func(c *Cache) {
		c.log = log
	}
}
