package rescache

import (
	"sync/atomic"
)

type Resource struct {
	ID       string
	Path     string
	Bytes    int64
	refCount int32
}

func (l *Resource) track() {
	atomic.AddInt32(&l.refCount, 1)
}

func (l *Resource) Release() {
	atomic.AddInt32(&l.refCount, -1)
}
