package resstorage

import (
	"a.yandex-team.ru/library/go/core/log"
)

type Option interface {
	isOption()
}

type maxSizeOption struct {
	Option
	maxSize int64
}

func WithMaxSize(size int64) Option {
	return maxSizeOption{
		maxSize: size,
	}
}

type loggerOption struct {
	Option
	log log.Logger
}

func WithLogger(log log.Logger) Option {
	return loggerOption{
		log: log,
	}
}
