package stringutil

import (
	"crypto/sha1"
	"encoding/hex"
)

func ShaHex(v ...string) string {
	h := sha1.New()
	for _, s := range v {
		_, _ = h.Write([]byte(s))
	}
	return hex.EncodeToString(h.Sum(nil))
}
