package yputil

import (
	"strconv"
	"strings"

	"a.yandex-team.ru/yp/go/yson/ypapi"
)

func DeployUnitPodSpec(duSpec *ypapi.TDeployUnitSpec) *ypapi.TPodSpec {
	if duSpec == nil {
		return nil
	}

	deployUnitPrimitive := duSpec.GetPodDeployPrimitive()
	if deployUnitPrimitive == nil {
		return nil
	}

	switch v := deployUnitPrimitive.(type) {
	case *ypapi.TDeployUnitSpec_ReplicaSet:
		replicaSet := v.Value.ReplicaSetTemplate
		if replicaSet == nil {
			break
		}

		if replicaSet.PodTemplateSpec == nil {
			break
		}

		return replicaSet.PodTemplateSpec.Spec
	case *ypapi.TDeployUnitSpec_MultiClusterReplicaSet:
		replicaSet := v.Value.ReplicaSet
		if replicaSet == nil {
			break
		}

		if replicaSet.PodTemplateSpec == nil {
			break
		}

		return replicaSet.PodTemplateSpec.Spec
	default:
		// TODO(buglloc): error needed
	}

	return nil
}

func AccountToABC(accountID string) int {
	if !strings.HasPrefix(accountID, "abc:service:") {
		return 0
	}

	abcID, err := strconv.Atoi(strings.TrimPrefix(accountID, "abc:service:"))
	if err != nil {
		return 0
	}
	return abcID
}
