package flakyimage

import (
	"fmt"

	"a.yandex-team.ru/security/xray/pkg/checks/check"
	"a.yandex-team.ru/security/xray/pkg/xrayrpc"
)

const (
	aboutURL    = "https://wiki.yandex-team.ru/security/x-ray/checks/#flakyimage"
	summary     = `Used the "latest" docker image tag`
	description = "Box uses the `%s` docker image with the `latest` tag.\n\n" +
		"It is recommended to always use an immutable tag, otherwise it leads to confusion of the used version on the cluster."
)

func FormatIssue(issue *xrayrpc.Issue) (*check.FormattedIssue, error) {
	details, ok := issue.Details.(*xrayrpc.Issue_FlakyImage)
	if !ok {
		return nil, check.ErrWrongIssueType
	}

	switch details.FlakyImage.ProblemKind {
	case xrayrpc.FlakyImageIssueDetail_FIIPK_LATEST_TAG:
		return &check.FormattedIssue{
			ID:          issue.Id,
			Summary:     summary,
			HelpURL:     aboutURL,
			Description: fmt.Sprintf(description, details.FlakyImage.Url),
		}, nil
	default:
		return nil, check.ErrUnknownKind
	}
}
