package gracefulshutdown

import (
	"a.yandex-team.ru/security/xray/pkg/checks/check"
	"a.yandex-team.ru/security/xray/pkg/xrayrpc"
)

const (
	aboutURL    = "https://wiki.yandex-team.ru/security/x-ray/checks/#gracefulshutdown"
	summary     = "Workload doesn't implement a graceful shutdown."
	description = "[Stop policy](https://deploy.yandex-team.ru/docs/concepts/pod/workload/probes#stop-policy) allows your workload to shutdown gracefully. " +
		"Don't ignore this feature, especially when processing external traffic."
)

func FormatIssue(issue *xrayrpc.Issue) (*check.FormattedIssue, error) {
	_, ok := issue.Details.(*xrayrpc.Issue_GracefulShutdown)
	if !ok {
		return nil, check.ErrWrongIssueType
	}

	return &check.FormattedIssue{
		ID:          issue.Id,
		Summary:     summary,
		HelpURL:     aboutURL,
		Description: description,
	}, nil
}
