package log4jfinder

import (
	"fmt"
	"strings"

	"a.yandex-team.ru/security/xray/pkg/checks/check"
	"a.yandex-team.ru/security/xray/pkg/xrayrpc"
)

const (
	aboutURL    = "https://clubs.at.yandex-team.ru/security/15211"
	summary     = `Found vulnerable log4j jar`
	description = "2.0 <= Apache log4j2 <= 2.15.0 are vulnerable to RCE, you must to update this dependency.\n\n" +
		"Jars:\n"
)

func FormatIssue(issue *xrayrpc.Issue) (*check.FormattedIssue, error) {
	details, ok := issue.Details.(*xrayrpc.Issue_Log4JFinder)
	if !ok {
		return nil, check.ErrWrongIssueType
	}

	if len(details.Log4JFinder.Jars) == 0 {
		return nil, check.ErrUnknownKind
	}

	var desc strings.Builder
	desc.WriteString(description)
	for _, jar := range details.Log4JFinder.Jars {
		desc.WriteString(fmt.Sprintf("  * %s (log4j-core v%s)", jar.Path, jar.Version))
	}

	return &check.FormattedIssue{
		ID:          issue.Id,
		Summary:     summary,
		HelpURL:     aboutURL,
		Description: desc.String(),
	}, nil
}
