package probelover

import (
	"a.yandex-team.ru/security/xray/pkg/checks/check"
	"a.yandex-team.ru/security/xray/pkg/xrayrpc"
)

const (
	aboutURL                           = "https://wiki.yandex-team.ru/security/x-ray/checks/#probelover"
	summaryNoReadiness                 = "Workload without Readiness probe"
	descriptionNoReadiness             = "Workload should always define its [Readiness probe](https://deploy.yandex-team.ru/docs/concepts/pod/workload/probes#readiness-proba) for smoother deployment and traffic routing."
	summaryReadinessSameToLiveness     = "Workload uses the same Readiness and Liveness probe"
	descriptionReadinessSameToLiveness = "This is a potentially dangerous situation where the Readiness and Liveness probes are the same. " +
		"Most likely this is a bug, please read more about [Workload probes](https://deploy.yandex-team.ru/docs/concepts/pod/workload/probes#o-pravilnom-napisanii-liveness-i-readiness-proby)"
)

func FormatIssue(issue *xrayrpc.Issue) (*check.FormattedIssue, error) {
	details, ok := issue.Details.(*xrayrpc.Issue_ProbeLover)
	if !ok {
		return nil, check.ErrWrongIssueType
	}

	var (
		summary string
		desc    string
	)
	switch details.ProbeLover.ProblemKind {
	case xrayrpc.ProbeLoverIssueDetail_PLIPK_NO_READINESS:
		summary = summaryNoReadiness
		desc = descriptionNoReadiness
	case xrayrpc.ProbeLoverIssueDetail_PLIPK_READINESS_SAME_TO_LIVENESS:
		summary = summaryReadinessSameToLiveness
		desc = descriptionReadinessSameToLiveness
	default:
		return nil, check.ErrUnknownKind
	}

	return &check.FormattedIssue{
		ID:          issue.Id,
		Summary:     summary,
		HelpURL:     aboutURL,
		Description: desc,
	}, nil
}
