package safenodes

import (
	"fmt"

	"a.yandex-team.ru/security/xray/pkg/checks/check"
	"a.yandex-team.ru/security/xray/pkg/xrayrpc"
)

const (
	aboutURL    = "https://wiki.yandex-team.ru/security/x-ray/checks/#safenodes"
	summary     = `Pod located on insecure nodes, but should not`
	description = `Stage refers to ABC service (https://abc.yandex-team.ru/services/%d) with doubled security controls. All pods of this service must runs on "safe" nodes`
)

func FormatIssue(issue *xrayrpc.Issue) (*check.FormattedIssue, error) {
	details, ok := issue.Details.(*xrayrpc.Issue_SafeNodes)
	if !ok {
		return nil, check.ErrWrongIssueType
	}

	var out *check.FormattedIssue
	switch details.SafeNodes.Kind {
	case xrayrpc.SafeNodesIssueDetail_SNI_EXPECTED_SAFE_NODE:
		out = &check.FormattedIssue{
			ID:          issue.Id,
			Summary:     summary,
			HelpURL:     aboutURL,
			Description: fmt.Sprintf(description, details.SafeNodes.AbcId),
		}
	default:
		return nil, check.ErrUnknownKind
	}

	return out, nil
}
