package soxer

import (
	"fmt"

	"a.yandex-team.ru/security/xray/pkg/checks/check"
	"a.yandex-team.ru/security/xray/pkg/xrayrpc"
)

const (
	aboutURL    = "https://wiki.yandex-team.ru/security/x-ray/checks/#soxer"
	summary     = `Stage must be explicitly marked as "Sox Service" or not.`
	description = "Stage refers to the ABC service (https://abc.yandex-team.ru/services/%d) with doubled security control. " +
		"All stages of this ABC service must have explicitly declared \"Sox Service\" (`/spec/sox_service`) field."
)

func FormatIssue(issue *xrayrpc.Issue) (*check.FormattedIssue, error) {
	details, ok := issue.Details.(*xrayrpc.Issue_Soxer)
	if !ok {
		return nil, check.ErrWrongIssueType
	}

	return &check.FormattedIssue{
		ID:          issue.Id,
		Summary:     summary,
		HelpURL:     aboutURL,
		Description: fmt.Sprintf(description, details.Soxer.AbcId),
	}, nil
}
