package spring4shellfinder

import (
	"fmt"
	"strings"

	"a.yandex-team.ru/security/xray/pkg/checks/check"
	"a.yandex-team.ru/security/xray/pkg/xrayrpc"
)

const (
	aboutURL    = "https://clubs.at.yandex-team.ru/security/15426"
	summary     = `Found vulnerable Spring dependencies`
	description = "Spring components are vulnerable to RCE, you must update these dependencies.\n\n" +
		"Jars:\n"
)

func FormatIssue(issue *xrayrpc.Issue) (*check.FormattedIssue, error) {
	details, ok := issue.Details.(*xrayrpc.Issue_Spring4ShellFinder)
	if !ok {
		return nil, check.ErrWrongIssueType
	}

	if len(details.Spring4ShellFinder.Jars) == 0 {
		return nil, check.ErrUnknownKind
	}

	var desc strings.Builder
	desc.WriteString(description)
	for _, jar := range details.Spring4ShellFinder.Jars {
		desc.WriteString(fmt.Sprintf("  * %s (%s v%s)", jar.Path, jar.Name, jar.Version))
	}

	return &check.FormattedIssue{
		ID:          issue.Id,
		Summary:     summary,
		HelpURL:     aboutURL,
		Description: desc.String(),
	}, nil
}
