package yodax

import (
	"bytes"
	"fmt"
	"strings"
	"text/template"

	"a.yandex-team.ru/security/xray/pkg/checks/check"
	"a.yandex-team.ru/security/xray/pkg/xrayrpc"
)

const (
	aboutURL = "https://wiki.yandex-team.ru/security/x-ray/checks/#yodax"
	summary  = `Nginx: %s`
)

var (
	description, _ = template.New("description").
		Parse(`
{{.Description}}

  - file path: {{.Path}}
{{ if .Reason}}  - reason: {{.Reason}} {{end}}

Pseudo config:
` + "```" + `
{{.Config}}
` + "```" + `
`)
)

func FormatIssue(issue *xrayrpc.Issue) (*check.FormattedIssue, error) {
	details, ok := issue.Details.(*xrayrpc.Issue_Yodax)
	if !ok {
		return nil, check.ErrWrongIssueType
	}

	var buf bytes.Buffer
	err := description.Execute(&buf, details.Yodax)
	if err != nil {
		return nil, fmt.Errorf("failed to format description: %w", err)
	}

	return &check.FormattedIssue{
		ID:          issue.Id,
		Summary:     fmt.Sprintf(summary, details.Yodax.GetSummary()),
		HelpURL:     aboutURL,
		Reference:   details.Yodax.Reference,
		Description: strings.TrimSpace(buf.String()),
	}, nil
}
