package collectors

import (
	"a.yandex-team.ru/security/xray/pkg/collectors/boxer"
	"a.yandex-team.ru/security/xray/pkg/collectors/collector"
	"a.yandex-team.ru/security/xray/pkg/collectors/log4jfinder"
	"a.yandex-team.ru/security/xray/pkg/collectors/secretsearch"
	"a.yandex-team.ru/security/xray/pkg/collectors/spring4shellfinder"
	"a.yandex-team.ru/security/xray/pkg/collectors/yadios"
	"a.yandex-team.ru/security/xray/pkg/collectors/yodax"
)

type Collectors map[collector.TargetKind][]collector.Collector

func NewCollectors(env collector.Config) Collectors {
	return Collectors{
		collector.TargetKindBoxFS: {
			boxer.New(env),
			yadios.New(env),
			log4jfinder.New(env),
			yodax.New(env),
			secretsearch.New(env),
			spring4shellfinder.New(env),
		},
	}
}
