package xray

import (
	"fmt"
	"sync"

	"google.golang.org/grpc"
	grpcCredentials "google.golang.org/grpc/credentials"

	"a.yandex-team.ru/library/go/certifi"
)

const (
	// TODO(buglloc): ugly hack to request internalCA, must be empty
	APIHostname = "api.xray.sec.yandex-team.ru"

	serviceConfigJSON = `{"loadBalancingPolicy":"round_robin"}`
)

var (
	creds     grpc.DialOption
	credsOnce sync.Once
)

func NewConnection(address string, opts ...grpc.DialOption) (*grpc.ClientConn, error) {
	return grpc.Dial(
		address,
		append(
			[]grpc.DialOption{
				grpc.WithDefaultServiceConfig(serviceConfigJSON),
				grpc.WithDisableServiceConfig(),
			},
			opts...,
		)...,
	)
}

func GRPCTransportCredentials(insecure bool) grpc.DialOption {
	if insecure {
		return grpc.WithInsecure()
	}

	return grpcCreds()
}

func grpcCreds() grpc.DialOption {
	credsOnce.Do(func() {
		certPool, err := certifi.NewCertPoolInternal()
		if err != nil {
			panic(fmt.Sprintf("failed to create cert pool: %s", err))
		}

		creds = grpc.WithTransportCredentials(
			grpcCredentials.NewClientTLSFromCert(certPool, APIHostname),
		)
	})

	return creds
}
