package abc

import (
	"a.yandex-team.ru/library/go/core/log"
)

type Option func(a *ABC)

func WithResolutionSequence(resolutionSequence []RoleName) Option {
	return func(a *ABC) {
		a.ResolutionSequence = resolutionSequence
	}
}

func WithLogger(logger log.Logger) Option {
	return func(a *ABC) {
		a.Logger = logger
		a.Client.SetLogger(logger.Fmt())
	}
}
