package abc

type Person struct {
	ID    int    `json:"id"`
	Login string `json:"login"`
	UID   string `json:"uid"`
}

type Service struct {
	ID   int    `json:"id"`
	Slug string `json:"slug"`
}

type Scope struct {
	Slug string `json:"slug"`
}

type Role struct {
	ID    int    `json:"id"`
	Scope Scope  `json:"scope"`
	Code  string `json:"code"`
}

type Department struct {
	URL string `json:"url"`
}

type DepartmentMember struct {
	Department Department `json:"department"`
}

type ABCServiceMembers struct {
	ID               int              `json:"id"`
	Person           Person           `json:"person"`
	Service          Service          `json:"service"`
	Role             Role             `json:"role"`
	DepartmentMember DepartmentMember `json:"department_member"`
}

type ABCResponseMembers struct {
	Next     *string             `json:"next"`
	Previous *string             `json:"previous"`
	Results  []ABCServiceMembers `json:"results"`
}

type ABCResource struct {
	ID         int           `json:"id"`
	ExternalID string        `json:"external_id"`
	Name       string        `json:"name"`
	Attributes []interface{} `json:"attributes"`
}

type ABCConsumerResult struct {
	ID       int         `json:"id"`
	Resource ABCResource `json:"resource"`
	Service  Service     `json:"service"`
	State    string      `json:"state"`
}

type ABCConsumerResponse struct {
	Next     *string             `json:"next"`
	Previous *string             `json:"previous"`
	Results  []ABCConsumerResult `json:"results"`
}
