package macros

import (
	"fmt"
	"net"
	"strconv"
	"strings"
)

func ExtractProjectID(ip net.IP) (*ProjectID, error) {
	ipv4 := ip.To4()
	if ipv4 != nil {
		return nil, fmt.Errorf("not ipv6")
	}

	b1 := int(ip[8])
	b2 := int(ip[9])
	b3 := int(ip[10])
	b4 := int(ip[11])
	pid := strings.TrimLeft(fmt.Sprintf("%02x%02x%02x%02x", b1, b2, b3, b4), "0")
	u, err := strconv.ParseUint(pid, 16, 32)
	if err != nil {
		return nil, err
	}

	projectID := ProjectID(u)

	return &projectID, nil
}
