package resolver

import (
	"a.yandex-team.ru/library/go/core/log"
)

type Option func(r *Resolver)

func WithResolverMaxDepth(depth int) Option {
	return func(r *Resolver) {
		r.ResolverMaxDepth = depth
	}
}

func WithLogger(logger log.Logger) Option {
	return func(r *Resolver) {
		r.Logger = logger
	}
}
