package resolver

func EstimateWeights(resolution Resolution) int {
	var baseWeight int
	var indirectPenalty int
	var inaccurateResolverPenalty int

	baseWeight = 70
	indirectPenalty = 0
	inaccurateResolverPenalty = 0

	for _, e := range resolution.Flow {
		switch {
		case e.Resolver == ResolverOwnersMacro:
			inaccurateResolverPenalty = inaccurateResolverPenalty + 40
		case e.Resolver == ResolverOwnersFQDN:
			inaccurateResolverPenalty = inaccurateResolverPenalty + 20
		case e.Resolver == ResolverMacro2PuncherResps:
			inaccurateResolverPenalty = inaccurateResolverPenalty + 10
		case e.Resolver == ResolverRacktablesNetworkResps:
			inaccurateResolverPenalty = inaccurateResolverPenalty + 5
		case e.Resolution == ReasonHeadOfDepartmentOfFiredPerson:
			indirectPenalty = indirectPenalty + 20
		case e.Resolution == ReasonRobotOwner:
			indirectPenalty = indirectPenalty + 10
		case e.Resolver == ResolverABCResource:
			inaccurateResolverPenalty = inaccurateResolverPenalty - 10
		}
	}

	switch resolution.Value {
	case "procenkoeg":
		indirectPenalty = indirectPenalty - 1
	case "aquila":
		indirectPenalty = indirectPenalty - 1
	}

	res := baseWeight - indirectPenalty - inaccurateResolverPenalty

	switch {
	case res < 0:
		res = 0
	case res > 100:
		res = 100
	}

	return res
}
