package staff

import (
	"a.yandex-team.ru/library/go/core/log"
)

type Option func(s *Staff)

func WithResolverMaxDepth(depth int) Option {
	return func(s *Staff) {
		s.ResolverMaxDepth = depth
	}
}

func WithLogger(logger log.Logger) Option {
	return func(s *Staff) {
		s.Logger = logger
		// s.Client.SetDebug(true)
		s.Client.SetLogger(logger.Fmt())
	}
}
