package staff

type Person struct {
	ID    int    `json:"id"`
	Login string `json:"login"`
	UID   string `json:"uid"`
}

type RobotOwnerEntry struct {
	Person Person `json:"person"`
}

type DepartmentHead struct {
	ID     int    `json:"id"`
	Person Person `json:"person"`
	Role   string `json:"role"`
}

type Department struct {
	Heads []DepartmentHead `json:"heads"`
	ID    int              `json:"id"`
	// Name string             `json:"name"`
	URL string `json:"url"`
}

type DepartmentGroup struct {
	Department Department `json:"department"`
	ID         int        `json:"id"`
	Name       string     `json:"name"`
	// Parent Department      `json:"parent"`
	URL string `json:"url"`
}

type OfficialInfo struct {
	IsDismissed bool `json:"is_dismissed"`
	IsRobot     bool `json:"is_robot"`
}

type StaffPerson struct {
	DepartmentGroup DepartmentGroup   `json:"department_group"`
	ID              int               `json:"id"`
	Login           string            `json:"login"`
	Official        OfficialInfo      `json:"official"`
	RobotOwners     []RobotOwnerEntry `json:"robot_owners"`
}

type StaffResult struct {
	Person StaffPerson `json:"person"`
}

type StaffResponse struct {
	Result []StaffResult `json:"result"`
}
