package walle

import (
	"crypto/tls"

	"github.com/go-resty/resty/v2"

	"a.yandex-team.ru/library/go/certifi"
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/nop"
)

type Client struct {
	Client resty.Client
	Logger log.Logger
}

func NewHTTPClient() (*resty.Client, error) {
	certPool, err := certifi.NewCertPool()
	if err != nil {
		return nil, err
	}

	httpClient := resty.New().
		SetRetryCount(2).
		SetHeader("User-Agent", "ya_resolve <security@yandex-team.ru>").
		SetTLSClientConfig(&tls.Config{RootCAs: certPool})

	return httpClient, nil
}

func NewClient(options ...ClientOption) (*Client, error) {
	httpClient, err := NewHTTPClient()
	if err != nil {
		return nil, err
	}

	client := Client{
		Client: *httpClient,
		Logger: &nop.Logger{},
	}

	for _, opt := range options {
		opt(&client)
	}

	return &client, nil
}
