package main

import (
	"fmt"
	"net/http"
	"net/url"
	"os"
	"path/filepath"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/security/yadi/fun/internal/config"
)

func newConfig() config.Config {
	var cfg config.Config

	switch os.Getenv("FUN_INSTALLATION") {
	case "prod":
		cfg = config.Config{
			Debug:    false,
			HTTPPort: 80,
			RedirectTo: url.URL{
				Scheme: "https",
				Host:   "yadi.yandex-team.ru",
				Path:   "/vulns/",
			},
		}
	case "dev", "test":
		fallthrough
	default:
		cfg = config.Config{
			Debug:    true,
			HTTPPort: 3000,
			RedirectTo: url.URL{
				Scheme: "https",
				Host:   "yadi-test.sec.yandex-team.ru",
				Path:   "/vulns/",
			},
		}
	}

	return cfg
}

func main() {
	var cfg = newConfig()
	e := echo.New()
	e.Debug = cfg.Debug
	e.HideBanner = true

	e.GET("/", func(c echo.Context) error {
		return c.Redirect(http.StatusFound, cfg.RedirectTo.String())
	})

	e.GET("/ping", func(c echo.Context) error {
		return c.String(http.StatusOK, "pong")
	})

	e.GET("/:vuln", func(c echo.Context) error {
		resultURL := cfg.RedirectTo
		resultURL.Path = filepath.Join(resultURL.Path, "vuln", c.Param("vuln"))
		return c.Redirect(http.StatusFound, resultURL.String())
	})

	err := e.Start(fmt.Sprintf(":%d", cfg.HTTPPort))
	if err != nil {
		panic(err)
	}
}
