package config

import (
	"a.yandex-team.ru/library/go/core/buildinfo"
	"a.yandex-team.ru/security/yadi/indexer/internal/db"
)

const (
	Version = "0.1"
)

var (
	fullVersion string
)

func FullVersion() string {
	if fullVersion != "" {
		return fullVersion
	}

	if buildinfo.Info.ArcadiaSourceRevision != "" {
		fullVersion = Version + "." + buildinfo.Info.ArcadiaSourceRevision
	} else {
		fullVersion = Version
	}

	return fullVersion
}

type Config struct {
	DryRun       bool
	Reindex      bool
	Concurrency  int
	YdbDatabase  string
	YdbPath      string
	YdbEndpoint  string
	YdbAuthToken string
}

func (c *Config) DBConfig() *db.Options {
	return &db.Options{
		Endpoint:  c.YdbEndpoint,
		Path:      c.YdbPath,
		Database:  c.YdbDatabase,
		AuthToken: c.YdbAuthToken,
	}
}
