package db

import (
	"fmt"
)

func selectPackageVersionQuery(pathPrefix string) string {
	return fmt.Sprintf(`
PRAGMA TablePathPrefix("%s");
DECLARE $name AS Utf8;
DECLARE $version AS Utf8;

SELECT
    license, pkg_url, requirements, updated_at
FROM
    package_versions
WHERE
	key = Digest::CityHash($name) AND name = $name AND version = $version
LIMIT 1
;`, pathPrefix)
}

func selectPackageQuery(pathPrefix string) string {
	return fmt.Sprintf(`
PRAGMA TablePathPrefix("%s");
DECLARE $name AS Utf8;

SELECT
    pkg_name, source, versions, updated_at
FROM
    packages
WHERE
	key = Digest::CityHash($name) AND name = $name
LIMIT 1
;`, pathPrefix)
}

func updatePackageLiteQuery(pathPrefix string) string {
	return fmt.Sprintf(`
PRAGMA TablePathPrefix("%s");
DECLARE $name AS Utf8;
DECLARE $pkgName AS Utf8;
DECLARE $source AS Utf8;
DECLARE $allVersions as Utf8;
DECLARE $updatedAt AS Int64;

REPLACE INTO packages
	(key, name, pkg_name, source, versions, updated_at)
VALUES
	(Digest::CityHash($name), $name, $pkgName, $source, $allVersions, $updatedAt)
;`, pathPrefix)
}

func updatePackageQuery(pathPrefix string) string {
	return fmt.Sprintf(`
PRAGMA TablePathPrefix("%s");
DECLARE $name AS Utf8;
DECLARE $pkgName AS Utf8;
DECLARE $source AS Utf8;
DECLARE $allVersions as Utf8;
DECLARE $updatedAt AS Int64;
DECLARE $versions AS "List<Struct<
    version: Utf8,
    license: Utf8,
    pkg_url: Utf8,
    requirements: Json>>";

$key = Digest::CityHash($name);

REPLACE INTO package_versions
    (key, name, version, license, pkg_url, requirements, updated_at)
SELECT 
    $key, $name, version, license, pkg_url, requirements, $updatedAt
FROM AS_TABLE($versions)
;

REPLACE INTO packages
	(key, name, pkg_name, source, versions, updated_at)
VALUES
	(Digest::CityHash($name), $name, $pkgName, $source, $allVersions, $updatedAt)
;`, pathPrefix)
}

func cleanUpPackageQuery(pathPrefix string) string {
	return fmt.Sprintf(`
PRAGMA TablePathPrefix("%s");
DECLARE $name AS Utf8;
DECLARE $versions AS "List<Utf8>";

$key = Digest::CityHash($name);

DELETE FROM
    package_versions
WHERE
    key = $key AND name = $name AND version IN $versions
;

DELETE FROM
    packages
WHERE
    key = $key AND name = $name
;`, pathPrefix)
}
