package dbmodels

import "time"

type (
	Package struct {
		Name      string    `json:"name"`
		PkgName   string    `json:"pkg_name"`
		Source    string    `json:"source"`
		Versions  []string  `json:"versions"`
		UpdatedAt time.Time `json:"updated_at"`
	}

	PackageVersion struct {
		Name         string      `json:"name"`
		Version      string      `json:"version"`
		License      string      `json:"license"`
		PkgURL       string      `json:"pkg_url"`
		Requirements interface{} `json:"requirements"`
		UpdatedAt    time.Time   `json:"updated_at"`
	}

	LitePackageVersion struct {
		Version      string
		License      string
		PkgURL       string
		Requirements []byte
	}
)
