package priority

import (
	"a.yandex-team.ru/security/yadi/libs/pypi"
)

var (
	priorities = map[string]int32{
		pypi.ExternalName: 1,
		pypi.YaTeamName:   2,
	}
)

func PyPiCleanup(current, target string) bool {
	switch {
	case current == target:
		return false
	case priorities[target] > priorities[current]:
		return true
	default:
		return false
	}
}

func PyPiSkip(current, target string) bool {
	switch {
	case current == target:
		return false
	case priorities[target] < priorities[current]:
		return true
	default:
		return false
	}
}
