package stat

import (
	"a.yandex-team.ru/library/go/core/xerrors"
)

type Limits struct {
	ExpectedPkgs       uint64
	AllowedPkgFails    uint64
	AllowedPkgVerFails uint64
}

func (l *Limits) CheckStats(stats Stat) error {
	switch {
	case stats.Packages < l.ExpectedPkgs:
		return xerrors.Errorf(
			"too few packages indexed: %d < %d",
			stats.Packages, l.ExpectedPkgs,
		)
	case stats.PackageFails > l.AllowedPkgFails:
		return xerrors.Errorf(
			"too many pkgs fails: %d > %d",
			stats.PackageFails, l.AllowedPkgFails,
		)
	case stats.PackageVersionFails > l.AllowedPkgVerFails:
		return xerrors.Errorf(
			"too many pkg version fails: %d > %d",
			stats.PackageVersionFails, l.AllowedPkgVerFails,
		)
	}

	return nil
}
