package stat

import (
	"sync/atomic"
	"time"
)

type Stat struct {
	Elapsed             time.Duration
	Packages            uint64
	PackageFails        uint64
	PackageVersionFails uint64
	NewPackageVersions  uint64

	startedAt time.Time
}

func New() *Stat {
	return &Stat{
		startedAt: time.Now(),
	}
}

func (s *Stat) AddPackage() {
	atomic.AddUint64(&s.Packages, 1)
}

func (s *Stat) AddPackageFail() {
	atomic.AddUint64(&s.PackageFails, 1)
}

func (s *Stat) AddPackageVersionFail() {
	atomic.AddUint64(&s.PackageVersionFails, 1)
}

func (s *Stat) AddNewPackageVersion() {
	s.AddNewPackageVersions(1)
}

func (s *Stat) AddNewPackageVersions(count uint64) {
	atomic.AddUint64(&s.NewPackageVersions, count)
}

func (s *Stat) Stat() Stat {
	return Stat{
		Elapsed:             time.Since(s.startedAt),
		Packages:            atomic.LoadUint64(&s.Packages),
		PackageFails:        atomic.LoadUint64(&s.PackageFails),
		PackageVersionFails: atomic.LoadUint64(&s.PackageVersionFails),
		NewPackageVersions:  atomic.LoadUint64(&s.NewPackageVersions),
	}
}
