package versions

import (
	"a.yandex-team.ru/security/libs/go/semver"
)

type Version struct {
	Raw    string
	Parsed *semver.Version
}

type Versions []Version

func (slice Versions) Len() int {
	return len(slice)
}

func (slice Versions) Less(i, j int) bool {
	if slice[i].Parsed == nil || slice[j].Parsed == nil {
		return false
	}

	return slice[i].Parsed.LessThan(slice[j].Parsed)
}

func (slice Versions) Swap(i, j int) {
	slice[i], slice[j] = slice[j], slice[i]
}
