package versions

import (
	"regexp"
	"sort"

	"a.yandex-team.ru/security/libs/go/semver"
)

var (
	clearVersionRe = regexp.MustCompile(`^v?((?:[0-9xX*]+)(?:\.[0-9xX*]+)?(?:\.[0-9xX*]+)?)[^,;:#]*`)
)

func SortVersions(versions []string) []string {
	parsed := make(Versions, len(versions))
	for i, v := range versions {
		cleared := clearVersionRe.FindStringSubmatch(v)
		var parsedVersion *semver.Version
		if len(cleared) > 0 {
			parsedVersion, _ = semver.NewVersion(cleared[1])
		}

		parsed[i] = Version{
			Raw:    v,
			Parsed: parsedVersion,
		}
	}

	sort.Sort(sort.Reverse(parsed))

	result := make([]string, len(parsed))
	for i, p := range parsed {
		result[i] = p.Raw
	}
	return result
}
