package qualifiers

import (
	"strings"
)

// Unknown string qualifiers
type UnknownQualifier struct {
	Version string
}

func (q UnknownQualifier) Compare(other Item) int {
	switch o := other.(type) {
	case KnownQualifier:
		return -1 // 1-alpha-2 > 1-ad0263a1fe56651ca4a89fdd95c745ea24286498
	case UnknownQualifier:
		return strings.Compare(q.Version, o.Version) // compare lexicographically
	default:
		return -1
	}
}

func (q UnknownQualifier) String() string {
	return q.Version
}

func NewUnknown(raw string) UnknownQualifier {
	return UnknownQualifier{Version: raw}
}
