package utils

import "strings"

// SplitNWithAnySep slices string "s" to n parts
// with one of the separate-characters from "sepset".
//
// The count determines the number of substrings to return:
//   n > 0: at most n substrings
//   n == 0: the result is nil (zero substrings)
//   n < 0: all substrings
//
// Only works for one-char separators, so
// SplitNWithAnySep("1.2.-3-.4.5-6", ".-", 4) will be ["1", "2", "3", "4.5.6"]
func SplitNWithAnySep(s, sepset string, n int) []string {
	if n == 0 {
		return nil
	}

	splitFunc := genSplitRule(sepset)
	substrings := strings.FieldsFunc(s, splitFunc)

	if n < 0 || len(substrings) == n {
		return substrings
	}

	var sepIndexes []int
	var sepIndex = -1
	for i := range substrings {
		if i == (len(substrings) - 1) {
			break // last group is w/o separator
		}
		sepIndex = sepIndex + len(substrings[i]) + 1
		sepIndexes = append(sepIndexes, sepIndex)
	}

	n = min(n, len(substrings))
	for l := len(substrings); l != n; {
		lastGroup := substrings[l-1]
		lastMinusOneGroup := substrings[l-2]
		lastSep := string(s[sepIndexes[l-2]])
		substrings = append(substrings[:len(substrings)-2], lastMinusOneGroup+lastSep+lastGroup)
		l = len(substrings)
	}
	return substrings
}

// genSplitRule generates function that splits the string (for strings.FieldsFunc)
// if rune is in the sepset
func genSplitRule(sepset string) func(r rune) bool {
	runes := []rune(sepset)
	return func(r rune) bool {
		for i := range runes {
			if r == runes[i] {
				return true
			}
		}
		return false
	}
}

func min(a, b int) int {
	if a < b {
		return a
	}
	return b
}
