package nvd

import "a.yandex-team.ru/library/go/ptr"

type nvdEntry struct {
	CVE struct {
		Meta struct {
			ID string `json:"ID"`
		} `json:"CVE_data_meta"`
		ProblemType struct {
			Data []struct {
				Description []struct {
					Value string `json:"value"`
				} `json:"description"`
			} `json:"problemtype_data"`
		} `json:"problemtype"`
		Description struct {
			Data []struct {
				Value string `json:"value"`
				Lang  string `json:"lang"`
			} `json:"description_data"`
		} `json:"description"`
	}
	Impact struct {
		BaseMetricV3 struct {
			CVSSV3 struct {
				BaseScore float32 `json:"baseScore"`
			} `json:"cvssV3"`
			ImpactScore float32 `json:"impactScore"`
		} `json:"baseMetricV3"`
		BaseMetricV2 struct {
			CVSSV2 struct {
				BaseScore float32 `json:"baseScore"`
			} `json:"cvssV2"`
			ImpactScore float32 `json:"impactScore"`
		} `json:"baseMetricV2"`
	} `json:"impact"`
	PublishedDate string `json:"publishedDate"`
	score         *float32
}

func (e *nvdEntry) Score() float32 {
	if e.score != nil {
		return *e.score
	}

	if e.Impact.BaseMetricV3.CVSSV3.BaseScore > 0.0 {
		e.score = &e.Impact.BaseMetricV3.CVSSV3.BaseScore
		return e.Impact.BaseMetricV3.CVSSV3.BaseScore
	}

	if e.Impact.BaseMetricV2.CVSSV2.BaseScore > 0.0 {
		e.score = &e.Impact.BaseMetricV2.CVSSV2.BaseScore
		return e.Impact.BaseMetricV2.CVSSV2.BaseScore
	}

	e.score = ptr.Float32(0.0)
	return 0.0
}
