package osreleases

import "fmt"

type Debian uint16

const (
	DebianUnknown  Debian = 0
	DebianEtch     Debian = 4
	DebianLenny    Debian = 5
	DebianSqueeze  Debian = 6
	DebianWheezy   Debian = 7
	DebianJessie   Debian = 8
	DebianStretch  Debian = 9
	DebianBuster   Debian = 10
	DebianBullseye Debian = 11
	DebianBookworm Debian = 12
	DebianTrixie   Debian = 13
	DebianSid      Debian = 99
)

func (r Debian) String() string {
	switch r {
	case DebianEtch:
		return "etch"
	case DebianLenny:
		return "lenny"
	case DebianSqueeze:
		return "squeeze"
	case DebianWheezy:
		return "wheezy"
	case DebianJessie:
		return "jessie"
	case DebianStretch:
		return "stretch"
	case DebianBuster:
		return "buster"
	case DebianBullseye:
		return "bullseye"
	case DebianBookworm:
		return "bookworm"
	case DebianTrixie:
		return "trixie"
	case DebianSid:
		return "sid"
	default:
		return fmt.Sprintf("unknown_%d", r)
	}
}

func DebianFromString(release string) Debian {
	switch release {
	case "etch":
		return DebianEtch
	case "lenny":
		return DebianLenny
	case "squeeze":
		return DebianSqueeze
	case "wheezy":
		return DebianWheezy
	case "jessie":
		return DebianJessie
	case "stretch":
		return DebianStretch
	case "buster":
		return DebianBuster
	case "bullseye":
		return DebianBullseye
	case "bookworm":
		return DebianBookworm
	case "trixie":
		return DebianTrixie
	case "sid":
		return DebianSid
	default:
		return DebianUnknown
	}
}
