package osreleases

import "fmt"

type Ubuntu uint16

const (
	UbuntuUnknown  Ubuntu = 0
	UbuntuLucid    Ubuntu = 1004
	UbuntuMaverick Ubuntu = 1010
	UbuntuPrecise  Ubuntu = 1204
	UbuntuQuantal  Ubuntu = 1210
	UbuntuRaring   Ubuntu = 1304
	UbuntuSaucy    Ubuntu = 1310
	UbuntuTrusty   Ubuntu = 1404
	UbuntuUtopic   Ubuntu = 1410
	UbuntuVivid    Ubuntu = 1504
	UbuntuWily     Ubuntu = 1510
	UbuntuXenial   Ubuntu = 1604
	UbuntuYakkety  Ubuntu = 1610
	UbuntuZesty    Ubuntu = 1704
	UbuntuArtful   Ubuntu = 1710
	UbuntuBionic   Ubuntu = 1804
	UbuntuCosmic   Ubuntu = 1810
	UbuntuDisco    Ubuntu = 1904
	UbuntuEoan     Ubuntu = 1910
	UbuntuFocal    Ubuntu = 2004
	UbuntuGroovy   Ubuntu = 2010
	UbuntuHirsute  Ubuntu = 2104
	UbuntuImpish   Ubuntu = 2110
	UbuntuJammy    Ubuntu = 2204
	UbuntuUpstream Ubuntu = 9999
)

func (r Ubuntu) String() string {
	switch r {
	case UbuntuUpstream:
		return "upstream"
	case UbuntuJammy:
		return "jammy"
	case UbuntuImpish:
		return "impish"
	case UbuntuHirsute:
		return "hirsute"
	case UbuntuGroovy:
		return "groovy"
	case UbuntuFocal:
		return "focal"
	case UbuntuEoan:
		return "eoan"
	case UbuntuDisco:
		return "disco"
	case UbuntuCosmic:
		return "cosmic"
	case UbuntuBionic:
		return "bionic"
	case UbuntuArtful:
		return "artful"
	case UbuntuZesty:
		return "zesty"
	case UbuntuYakkety:
		return "yakkety"
	case UbuntuXenial:
		return "xenial"
	case UbuntuWily:
		return "wily"
	case UbuntuVivid:
		return "vivid"
	case UbuntuUtopic:
		return "utopic"
	case UbuntuTrusty:
		return "trusty"
	case UbuntuSaucy:
		return "saucy"
	case UbuntuRaring:
		return "raring"
	case UbuntuQuantal:
		return "quantal"
	case UbuntuPrecise:
		return "precise"
	case UbuntuMaverick:
		return "maverick"
	case UbuntuLucid:
		return "lucid"
	default:
		return fmt.Sprintf("unknown_%d", r)
	}
}

func UbuntuFromString(release string) Ubuntu {
	switch release {
	case "upstream":
		return UbuntuUpstream
	case "jammy":
		return UbuntuJammy
	case "impish":
		return UbuntuImpish
	case "hirsute":
		return UbuntuHirsute
	case "groovy":
		return UbuntuGroovy
	case "focal":
		return UbuntuFocal
	case "eoan":
		return UbuntuEoan
	case "disco":
		return UbuntuDisco
	case "cosmic":
		return UbuntuCosmic
	case "bionic":
		return UbuntuBionic
	case "artful":
		return UbuntuArtful
	case "zesty":
		return UbuntuZesty
	case "yakkety":
		return UbuntuYakkety
	case "xenial":
		return UbuntuXenial
	case "wily":
		return UbuntuWily
	case "vivid":
		return UbuntuVivid
	case "utopic":
		return UbuntuUtopic
	case "trusty":
		return UbuntuTrusty
	case "saucy":
		return UbuntuSaucy
	case "raring":
		return UbuntuRaring
	case "quantal":
		return UbuntuQuantal
	case "precise":
		return UbuntuPrecise
	case "maverick":
		return UbuntuMaverick
	case "lucid":
		return UbuntuLucid
	default:
		return UbuntuUnknown
	}
}
