package pypi

import (
	"os"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/security/libs/go/pypi/repos/pypilocalshop"
	"a.yandex-team.ru/security/libs/go/pypi/repos/pypipypi"
	"a.yandex-team.ru/security/libs/go/pypi/repos/pypisimple"
)

func NewYandexTeamSimple() (*PyPi, error) {
	client, err := pypisimple.New(pypisimple.Options{
		Name:       YaTeamName,
		BaseURL:    YaTeamHost,
		HTTPClient: httpClient,
	})
	if err != nil {
		return nil, err
	}

	return &PyPi{
		client: client,
	}, nil
}

func NewYandexTeamLocal() (*PyPi, error) {
	// TODO(buglloc): request oauth&json, please-please-please-please
	pypiLogin := os.Getenv("PYPI_LOGIN")
	if pypiLogin == "" {
		return nil, xerrors.New("empty env[PYPI_LOGIN]")
	}

	pypiPass := os.Getenv("PYPI_PASSWORD")
	if pypiPass == "" {
		return nil, xerrors.New("empty env[PYPI_PASSWORD]")
	}

	client, err := pypilocalshop.New(pypilocalshop.Options{
		Name:      YaTeamName,
		BaseURL:   YaTeamHost,
		LocalOnly: true,
		Login:     pypiLogin,
		Password:  pypiPass,
	})
	if err != nil {
		return nil, err
	}

	return &PyPi{
		client: client,
	}, nil
}

func NewPyPiOrg() (*PyPi, error) {
	client, err := pypipypi.New(pypipypi.Options{
		Name:       ExternalName,
		BaseURL:    ExternalHost,
		HTTPClient: httpClient,
	})
	if err != nil {
		return nil, err
	}

	return &PyPi{
		client: client,
	}, nil
}
